<div class="card">
  <div class="card-header with-icon">
    <i class="fa fa-stopwatch mr10"></i>{__("Changelog")}
  </div>
  <div class="card-body">

    <div class="alert alert-info">
      <div class="icon">
        <i class="fa fa-info-circle fa-2x"></i>
      </div>
      <div class="text pt5">
        {__("All Updates are FREE for life-time if you own valid purchase code, don't have one?")} <a href="https://bit.ly/BuySngine" target="_blank">{__("Purchase Now")}</a>
      </div>
    </div>

    <!-- Changelog -->
    <h3>Version <span class="badge bg-warning rounded-pill">3.9.1</span></h3>
    <blockquote>Release Date: 17th June 2023</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Minor Bugs</li>
      <li>[Fixed] Cover image position issue</li>
      <li>[Fixed] DataTables alert issue when edit user in admin panel</li>
      <li>[Fixed] Critical Security Issues & Thanks to @IlyasMakari (https://twitter.com/IlyasMakari)</li>
      <li>[Fixed] Profile picture when start chat from profile, market, popover ...etc</li>
      <li>[Fixed] Replaced CDN for "Bootstrap" & "tinymce-i18n" with local files (JsDeliver CDN has some issues with some countries)</li>
      <li>[Fixed] Fixed "Forget Password" link position</li>
      <li>[Fixed] Admin panel badge text white colors in day mode</li>
      <li>[Fixed] Stories Issue</li>
      <li>[Fixed] Fundings Permission</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.9</span></h3>
    <blockquote>Release Date: 5th June 2023</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine PHP Dependencies</li>
      <li>[Updated] Sngine JS Dependencies</li>

      <li>[Added] Migrate to Bootstrap v5+</li>
      <li>[Added] New Default Theme</li>
      <li>[Added] Fluid Design Option</li>
      <li>[Added] Admin ability to turn Fluid Design Option On/Off [Admin Panel]</li>
      <li>[Added] Change Icons Colors [Admin Panel]</li>
      <li>[Added] New Social Login via WordPress</li>
      <li>[Added] New System Ads Slot For Specific Pages</li>
      <li>[Added] New System Ads Slot For Specific Groups</li>
      <li>[Added] Emojis Menu Lazy Loading</li>
      <li>[Added] MoneyPoolsCash Automatic Withdrawal Payments</li>
      <li>[Added] Movies Pay Per View Module</li>
      <li>[Added] Switch Accounts</li>
      <li>[Added] Share Stories As Ads</li>
      <li>[Added] Videos Categories</li>
      <li>[Added] Manage Videos Categories [Admin Panel]</li>
      <li>[Added] Manage Custom Users Groups [Admin Panel]</li>
      <li>[Added] Manage Permissions Groupss [Admin Panel]</li>
      <li>[Added] Pro Packages With Permissions Groups [Admin Panel]</li>
      <li>[Added] Pro Packages With Picked Videos Categories Access [Admin Panel]</li>
      <li>[Added] Pro Packages With Picked Blogs Categories Access [Admin Panel]</li>
      <li>[Added] Admin ability to turn Verification Docs On/Off [Admin Panel]</li>
      <li>[Added] Make “Boosted” Posts Visible To Website Visitors</li>
      <li>[Added] Uploads Permission for Non-Logged In Users</li>
      <li>[Added] Change Profile Picture from Old Photos</li>
      <li>[Added] Change Page Picture from Old Photos</li>
      <li>[Added] Change Group Picture from Old Photos</li>

      <li>[Fixed] Minor Bugs</li>
      <li>[Fixed] Games Genres Issue</li>
      <li>[Fixed] Publisher Privacy Dropdown Menu in Mobile</li>
      <li>[Fixed] Video Player Aspect Ratio</li>
      <li>[Fixed] Stripe with JPY currency</li>
      <li>[Fixed] Backup contains content\backups folder</li>
      <li>[Fixed] Facebook Embed Responsive Issue</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.8</span></h3>
    <blockquote>Release Date: 31st March 2023</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine PHP Dependencies</li>
      <li>[Updated] Sngine JS Dependencies</li>
      <li>[Added] New Landing Page Design</li>
      <li>[Added] Watch Module</li>
      <li>[Added] Tips Module</li>
      <li>[Added] Content Monetization Custom Plans Module</li>
      <li>[Added] Reactions Order [Admin Panel]</li>
      <li>[Added] Allow Animated Images for Avatars/Covers</li>
      <li>[Added] Admin ability to turn Animated Images On/Off [Admin Panel]</li>
      <li>[Added] Games Genres</li>
      <li>[Added] Discover Pages by Categories</li>
      <li>[Added] Discover Groups by Categories</li>
      <li>[Added] Discover Events by Categories</li>
      <li>[Added] Discover Games By Genres</li>
      <li>[Added] Edit Pages Description SEO [Admin Panel]</li>
      <li>[Added] Edit Groups Description SEO [Admin Panel]</li>
      <li>[Added] Edit Events Description SEO [Admin Panel]</li>
      <li>[Added] Edit Games Description SEO [Admin Panel]</li>
      <li>[Added] Manage DayTime Messages [Admin Panel]</li>
      <li>[Added] List Marketplace Posts [Admin Panel]</li>
      <li>[Added] Backbalze New Location [Admin Panel]</li>
      <li>[Added] Moneypoolscash Payment Gateway</li>
      <li>[Added] Show Ads Campaigns for Non-logged-in Members</li>
      <li>[Fixed] Pages Fake Generator</li>
      <li>[Fixed] Bank Transfers Accept [Admin Panel]</li>
      <li>[Fixed] Highcharts.js Translation [Admin Panel]</li>
      <li>[Fixed] Group Cover Image Position Issue</li>
      <li>[Fixed] Post Title With Feelings Issue</li>
      <li>[Fixed] Super Admin Can't Be Demo Account</li>
      <li>[Fixed] Dark Logo If Not Uploaded</li>
      <li>[Fixed] Advanced Search With Empty Query Links Issue</li>
      <li>[Fixed] Friends Count To Exclude Banned Users</li>
      <li>[Fixed] Posts limit/hours for articles</li>
      <li>[Fixed] Fullname in Forums if Usernames Only Enabled</li>
      <li>[Fixed] Deleting Comments When Post Deleted</li>
      <li>[Fixed] Deleting Article Cover Image When Article Deleted</li>
      <li>[Fixed] Pinned Post Twice Views</li>
      <li>[Fixed] Promoted Jobs Not Open</li>
      <li>[Fixed] Images & Videos Aspect Ratio</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.7</span></h3>
    <blockquote>Release Date: 1st January 2023</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine PHP Dependencies</li>
      <li>[Updated] Sngine JS Dependencies</li>
      <li>[Added] Content Monetization for [Profiles|Pages|Groups]</li>
      <li>[Added] Manage Reactions [Admin Panel]</li>
      <li>[Added] Add Follower/Followings Privacy Settings</li>
      <li>[Added] Ads Free System for Pro Accounts</li>
      <li>[Added] Admin ability to turn Ads Free System On/Off [Admin Panel]</li>
      <li>[Added] Posts Count in [Profile|Page|Group|Event]</li>
      <li>[Added] Photos Count in [Profile|Page|Group|Event]</li>
      <li>[Added] Videos Count in [Profile|Page|Group|Event]</li>
      <li>[Added] Who can Send Gifts [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Upload Videos [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Upload Audios [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Upload Files [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Add Colored Posts [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Add Feelings/Activity Posts [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Add Poll Posts [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Add Geolocation Posts [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Add GIF Posts [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Who can Post As Anonymous [Everyone|Verified|Pro|Admins]</li>
      <li>[Added] Stripe New Checkout APIs</li>
      <li>[Added] Dark|Light Logo [Admin Panel]</li>
      <li>[Added] Mixcloud Support</li>
      <li>[Added] Backblaze Bucket Region "eu-central-003" [Admin Panel]</li>
      <li>[Fixed] FastCGI Issue</li>
      <li>[Fixed] Pro System Charts in Admin Panel</li>
      <li>[Fixed] Pro Earning of Current Month</li>
      <li>[Fixed] Disabled Currencies in Admin Panel</li>
      <li>[Fixed] Auto Followings Check</li>
      <li>[Fixed] Quick Search Log Check</li>
      <li>[Fixed] Delete Original Video After FFmpeg Convert</li>
      <li>[Fixed] Backups Function</li>
      <li>[Fixed] Campaign Potential Reach</li>
      <li>[Fixed] RazorPay Issue</li>
      <li>[Fixed] Stories Preview Issue with Videos</li>
      <li>[Fixed] Mass Notifications Extrenal Link Open New Tab</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.6.3</span></h3>
    <blockquote>Release Date: 12th October 2022</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Categories Translation</li>
      <li>[Fixed] FFmpeg issue with Cloud Saving</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.6.2</span></h3>
    <blockquote>Release Date: 20th September 2022</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Sngine Default Theme Colors</li>
      <li>[Added] New Post Reactions Images</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.6.1</span></h3>
    <blockquote>Release Date: 12th September 2022</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Newsfeed Countries Issue</li>
      <li>[Fixed] @mentions Issue</li>
      <li>[Fixed] Save To Cloud Storage Issue</li>
      <li>[Fixed] Vkontakte Adaptor Issue</li>
      <li>[Fixed] Tinymce Uploading Images Issue</li>
      <li>[Fixed] Custom CSS Colors Issue</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.6</span></h3>
    <blockquote>Release Date: 1st September 2022</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine PHP Dependencies</li>
      <li>[Updated] Sngine JS Dependencies</li>
      <li>[Added] Move Sngine JS Dependencies to NPM</li>
      <li>[Added] FFMPEG Support</li>
      <li>[Added] Admin ability to turn FFMPEG On/Off [Admin Panel]</li>
      <li>[Added] All Comments Sorting in Comments</li>
      <li>[Added] Backblaze Cloud Storage</li>
      <li>[Added] Manage Reserved Usernames [Admin Panel]</li>
      <li>[Added] Profile Image Required While Sign Up On/Off [Admin Panel]</li>
      <li>[Added] Location Data Required While Sign Up On/Off [Admin Panel]</li>
      <li>[Added] Education Data Required While Sign Up On/Off [Admin Panel]</li>
      <li>[Added] Work Data Required While Sign Up On/Off [Admin Panel]</li>
      <li>[Added] Allow Special Characters in Names [Admin Panel]</li>
      <li>[Added] Share the post to Event</li>
      <li>[Added] Publish Articles Inside Pages</li>
      <li>[Added] Publish Articles Inside Groups</li>
      <li>[Added] Publish Articles Inside Events</li>
      <li>[Added] Posts Views System</li>
      <li>[Added] Admin ability to turn Posts Views System On/Off [Admin Panel]</li>
      <li>[Added] Points/Post View in Points System</li>
      <li>[Added] Custom Countries for Auto-Friend Feature</li>
      <li>[Added] Custom Countries for Auto-Follow Feature</li>
      <li>[Added] Custom Countries for Auto-Like Feature</li>
      <li>[Added] Custom Countries for Auto-Join Feature</li>
      <li>[Added] Native Emojis Support</li>
      <li>[Added] Newsfeed Location Filter</li>
      <li>[Added] Admin ability to Enable/Disable Any Currency [Admin Panel]</li>
      <li>[Added] Pro Package Badge with Comments</li>
      <li>[Added] Video.js Langauges</li>
      <li>[Added] New Ads Positions Under The Post & Article</li>
      <li>[Added] Stories Preview</li>
      <li>[Fixed] Agora Cloud Recording</li>
      <li>[Fixed] Wasabi Files Delete After Deleting The Post</li>
      <li>[Fixed] Update Pages, Groups & Events Counters When Delete User</li>
      <li>[Fixed] Default Website Description Translation</li>
      <li>[Fixed] Odysee.com Scraper Bug</li>
      <li>[Fixed] Dark Mode Pagination Colors</li>
      <li>[Fixed] Live Video Screenshot</li>
      <li>[Fixed] Video Calls UI</li>
      <li>[Fixed] User Online Bug</li>
      <li>[Fixed] Offers Date Format Match System Date Format</li>
      <li>[Fixed] Delete Album Photos After Load More</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.5</span></h3>
    <blockquote>Release Date: 5th June 2022</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs</li>
      <li>[Updated] Sngine JS Dependencies</li>

      <li>[Added] Move libs to Composer</li>
      <li>[Added] Razorpay Payment Method</li>
      <li>[Added] Cashfree Payment Method</li>
      <li>[Added] Coinbase Payment Method</li>
      <li>[Added] SecurionPay Payment Method</li>
      <li>[Added] Live Streaming on Pages</li>
      <li>[Added] Live Streaming on Groups</li>
      <li>[Added] Live Streaming on Events</li>
      <li>[Added] Copy Post Link to Clipboard</li>
      <li>[Added] Account Activation Required</li>
      <li>[Added] Admin ability to turn Activation Required On/Off [Admin Panel]</li>
      <li>[Added] @mentions Now Support Any Language</li>
      <li>[Added] Translate Site Title To User Language</li>
      <li>[Added] Google Cloud Storage</li>
      <li>[Added] Admin ability to turn Google Cloud Storage On/Off [Admin Panel]</li>
      <li>[Added] Category Name with Product Details</li>
      <li>[Added] Report Categories and Report Reason</li>
      <li>[Added] Admin ability to Manage Report Categories [Admin Panel]</li>
      <li>[Added] Admin ability to Manage HTML support in Rich Text Editor [Admin Panel]</li>
      <li>[Added] Search Box in Blogs Module</li>
      <li>[Added] Different Currencies per Product</li>
      <li>[Added] Remove Upload Limits for Admins/Mods</li>

      <li>[Fixed] Re-Share Public Group Post</li>
      <li>[Fixed] Blog Comments For Visitors</li>
      <li>[Fixed] Delete Reports If Content Already Deleted</li>
      <li>[Fixed] Translation [Select All|Deselect All|Nothing Selected] in Ads Manager</li>
      <li>[Fixed] Multiple Select Custom Field Value</li>
      <li>[Fixed] Lightbox Arrows Directions in RTL Languages</li>
      <li>[Fixed] Video loaded with "View X New Posts" Not Playing</li>
      <li>[Fixed] Edit Comment reflected on Replies Bug</li>
      <li>[Fixed] Adblock Detector</li>
      <li>[Fixed] Rumble.com Videos</li>
      <li>[Fixed] Banned.Video Videos</li>
      <li>[Fixed] Brighteon Videos</li>
      <li>[Fixed] Mutual Friends Loader</li>
      <li>[Fixed] User Name on Video/Audio Calls</li>
      <li>[Fixed] Disabled Countries Issue</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.4</span></h3>
    <blockquote>Release Date: 10th February 2022</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|HTMLPurifier|PHPMailer|SimpleImage|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [tagify]</li>

      <li>[Added] Wasabi Cloud Storage</li>
      <li>[Added] Free Trial Pro Packages</li>
      <li>[Added] Sorting in Jobs</li>
      <li>[Added] Filter by location in Jobs</li>
      <li>[Added] Sorting in Offers</li>
      <li>[Added] Filter by location in Offers</li>
      <li>[Added] Filter by location in Marketplace</li>
      <li>[Added] Pro Packages Order</li>
      <li>[Added] Newsfeed Module Publicly Accessible</li>
      <li>[Added] Admin ability to turn Newsfeed Public On/Off [Admin Panel]</li>
      <li>[Added] Pages Module Publicly Accessible</li>
      <li>[Added] Groups Module Publicly Accessible</li>
      <li>[Added] Events Module Publicly Accessible</li>
      <li>[Added] Games Module Publicly Accessible</li>
      <li>[Added] Developers Module Publicly Accessible</li>
      <li>[Added] Photos in Lightbox Mode Publicly Accessible</li>
      <li>[Added] Allow Uploading .webp Images</li>
      <li>[Added] Max Results for Marketplace [Admin Panel]</li>
      <li>[Added] Max Results for Offers [Admin Panel]</li>
      <li>[Added] Max Results for Jobs [Admin Panel]</li>
      <li>[Added] Max Results for Games [Admin Panel]</li>
      <li>[Added] Max Results for Search [Admin Panel]</li>
      <li>[Added] Advanced Search System (Load More Results)</li>
      <li>[Added] Auto-Play Videos</li>
      <li>[Added] Admin ability to turn Auto-Play Videos On/Off [Admin Panel]</li>
      <li>[Added] Copy Affiliates Link to Clipboard</li>
      <li>[Added] Languages Order</li>
      <li>[Added] Countries Module [Admin Panel]</li>
      <li>[Added] Default System Country</li>
      <li>[Added] Multiple Select Custom Field</li>
      <li>[Added] Custom Fields for Products</li>
      <li>[Added] Custom Fields for Jobs</li>
      <li>[Added] Custom Fields for Offers</li>
      <li>[Added] Search With Custom Fields</li>
      <li>[Added] Twitch Profile URL</li>
      <li>[Added] Save Button on Edit Post</li>
      <li>[Added] Save Button on Edit Comment</li>
      <li>[Added] Login Modal for User Actions (Add Friend, Like Page ... etc)</li>
      <li>[Added] Validations on all admin -> categories add/edit modules</li>

      <li>[Fixed] Post/Photo Privacy Check Error</li>
      <li>[Fixed] Censored Words Bug</li>
      <li>[Fixed] Voice Notes Bug</li>
      <li>[Fixed] Directory Orphan Data Bug</li>
      <li>[Fixed] Album Title Translation</li>
      <li>[Fixed] Article Category Name Translation</li>
      <li>[Fixed] Forums Names Translation</li>
      <li>[Fixed] Custom Pro Package Message Translation</li>
      <li>[Fixed] Custom Field Label Translation</li>
      <li>[Fixed] Ban Super Admin</li>
      <li>[Fixed] Long Vertical Images</li>
      <li>[Fixed] Long Vertical Videos</li>
      <li>[Fixed] Lightbox Close Button</li>
      <li>[Fixed] Add/Edit System Ads Dropdown Menu</li>
      <li>[Fixed] Remove user from all joined groups/events when delete user</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.3</span></h3>
    <blockquote>Release Date: 25th November 2021</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|GettextTranslator|PHPMailer|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [easytimer|tagify|tinymce]</li>
      <li>[Added] View X New Posts in Newsfeed</li>
      <li>[Added] Multi-Level Affiliates System</li>
      <li>[Added] ADS Approval System</li>
      <li>[Added] Position of the Currency Symbol (Left|Right)</li>
      <li>[Added] Voice Note Encoding (MP3|OGG|WAV)</li>
      <li>[Added] Voice Note Duration</li>
      <li>[Added] Uploads CDN</li>
      <li>[Added] Custom Ban Message</li>
      <li>[Added] Custom Pro Package Message</li>
      <li>[Added] Upgraded Page after Buying Pro Package</li>
      <li>[Added] Fake Pages Generator</li>
      <li>[Added] Fake Groups Generator</li>
      <li>[Added] Points/Follower in Points System</li>
      <li>[Added] Points/Referred in Points System</li>
      <li>[Added] Max Results for Newsfeed Posts [Admin Panel]</li>
      <li>[Added] Max Results for Pages [Admin Panel]</li>
      <li>[Added] Max Results for Groups [Admin Panel]</li>
      <li>[Added] Max Results for Events [Admin Panel]</li>
      <li>[Added] Phone Code in Signup Form</li>
      <li>[Added] Lightbox Download Button</li>
      <li>[Added] Translate Countries Names</li>
      <li>[Added] Translate Package Name in Packages Page</li>
      <li>[Added] Translate Blog Categories in Article Page</li>
      <li>[Added] Show Stories From All Users</li>
      <li>[Fixed] Max Posts Limit for Pages </li>
      <li>[Fixed] Header/Footer Ads</li>
      <li>[Fixed] Donate Permission</li>
      <li>[Fixed] Header Menu Scroll</li>
      <li>[Fixed] Forum Thread/Reply Username Bug</li>
      <li>[Fixed] Languages Menu CSS</li>
      <li>[Fixed] Recorded Audio in IOS</li>
      <li>[Fixed] Lightbox UI</li>
      <li>[Fixed] Odysee.com Scraper Bug</li>
      <li>[Fixed] Back Home After Deleting Post</li>
      <li>[Fixed] User Biography Mutiple Lines</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.2.1</span></h3>
    <blockquote>Release Date: 25th August 2021</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Edit user bug</li>
      <li>[Fixed] Audio/Video Calls & Live Streaming on IOS</li>
      <li>[Fixed] Agora Live Stream Recoding</li>
      <li>[Fixed] PayStack 404 Error</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>

    <h3>Version <span class="badge bg-warning rounded-pill">3.2</span></h3>
    <blockquote>Release Date: 15th August 2021</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [Agora|AWS|Embed|FtpClient|GettextTranslator|GoogleAuthenticator|PHPMailer|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [jQuery|Agora|autosize|bootstrap.colorpicker|codemirror|easytimer|tagify|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] UI Enhancements</li>
      <li>[Added] Invitations System</li>
      <li>[Added] Factory Reset [Admin Panel]</li>
      <li>[Added] Demo Account Mode</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Pages</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Groups</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Events</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Blogs</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Marketplace</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Offers</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Jobs</li>
      <li>[Added] Sub-Categories (Infinite Levels) for Developers Apps</li>
      <li>[Added] Google Play Store Badge on Landing Page</li>
      <li>[Added] Huawei AppGallery Badge on Landing Page</li>
      <li>[Added] Apple App Store Badge on Landing Page</li>
      <li>[Added] "Subscription is Required" Message if Subscription is enabled</li>
      <li>[Added] Remove Relationship from Find People if disabled from admin panel</li>
      <li>[Added] Remove Relationship from Ads Campaigns if disabled from admin panel</li>
      <li>[Added] Remove Relationship from Privacy Settings if disabled from admin panel</li>
      <li>[Added] Remove Work Info from Privacy Settings if disabled from admin panel</li>
      <li>[Added] Remove Location Info from Privacy Settings if disabled from admin panel</li>
      <li>[Added] Remove Education Info from Privacy Settings if disabled from admin panel</li>
      <li>[Added] Twemoji-amazing instead of outdated twemoji-awesome with 3500+ emojis</li>
      <li>[Added] Super Admin Account can't be edited/deleted</li>
      <li>[Added] Delete Button in Edit Page Edit [Admin Panel]</li>
      <li>[Added] Delete Button in Edit Group Edit [Admin Panel]</li>
      <li>[Added] Delete Button in Edit Event Edit [Admin Panel]</li>
      <li>[Added] Refund the user when admin rejects Wallet Withdrawal Request</li>
      <li>[Added] Refund the user when admin rejects Affiliates Withdrawal Request</li>
      <li>[Added] Refund the user when admin rejects Points Withdrawal Request</li>
      <li>[Added] Refund the user when admin rejects Funding Withdrawal Request</li>
      <li>[Fixed] Live Stream on Mobile & Update Agora SDK to v4.x</li>
      <li>[Fixed] Audio/Video Calls & Update Twilio SDK to v2.x</li>
      <li>[Fixed] Add more photos in albums</li>
      <li>[Fixed] Share posts to groups with approval system</li>
      <li>[Fixed] Reactions on iPad</li>
      <li>[Fixed] Google Maps Auto-complete</li>
      <li>[Fixed] Link Scraper</li>
      <li>[Fixed] Readmore.js Height</li>
      <li>[Fixed] Video/Audio Views for Shared Post</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">3.1</span></h3>
    <blockquote>Release Date: 30th May 2021</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|GettextTranslator|HybridAuth|MobileDetect|PHPMailer|SimpleImage|Smarty|Spaces|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [autosize|bootstrap.colorpicker|codemirror|easytimer|mustache|tagify|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Add Button in Header</li>
      <li>[Added] Funding System</li>
      <li>[Added] Paystack Payments</li>
      <li>[Added] Msg91 SMS Gateway</li>
      <li>[Added] Stories Permission (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Ads Permission (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Audio Calls Permission (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Video Calls Permission (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] View All Posts Option [Admin Panel]</li>
      <li>[Added] Invite by Phone Number</li>
      <li>[Added] Share Posts from Public Groups</li>
      <li>[Added] Share Posts from Public Events</li>
      <li>[Added] Edit Name Minimum Length [Admin Panel]</li>
      <li>[Added] Change Modules Descriptions from Admin Panel [Admin Panel]</li>
      <li>[Added] Hide Banned Users from Search Results</li>
      <li>[Added] Hide Banned Users from Friends, Followings & Followers List</li>
      <li>[Added] Hide Banned User's Posts</li>
      <li>[Added] Display Package Name when hover on Pro Badge</li>
      <li>[Added] Honeypot Check to stop Spammers</li>
      <li>[Fixed] Remove Location Permission [Android App]</li>
      <li>[Fixed] Google login issue [Android App]</li>
      <li>[Fixed] Event's date Translation</li>
      <li>[Fixed] OneSignal Push Notifications</li>
      <li>[Fixed] URL in user first|last name</li>
      <li>[Fixed] Youtube scaper height</li>
      <li>[Fixed] Genders Translation</li>
      <li>[Fixed] Theme must be enabled to work as default theme</li>
      <li>[Fixed] Chat issue when with blocked user</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">3.0</span></h3>
    <blockquote>Release Date: 31th January 2021</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|Faker|FTP|HybridAuth|MobileDetect|PHPMailer|SimpleImage|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [bootstrap.datetimepicker|codemirror|easytimer|moment|mustache|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Bootstrap|Font-Awesome]</li>
      <li>[Added] Changed DB from MYISAM to INNODB</li>
      <li>[Added] Background Thread for time-consuming tasks like send newsletter, garbage collector ...etc</li>
      <li>[Added] Theme Switcher</li>
      <li>[Added] Wallet Withdrawals</li>
      <li>[Added] Admin ability to turn the Wallet Withdrawals On/Off [Admin Panel]</li>
      <li>[Added] Manage Genders [Admin Panel]</li>
      <li>[Added] Gender Privacy</li>
      <li>[Added] Sorting in Marketplace</li>
      <li>[Added] Delete For Everyone with Chat</li>
      <li>[Added] Links to Custom Fields</li>
      <li>[Added] Changing Username/Name remove the Verification Badge</li>
      <li>[Added] Show only Usernames instead of Full Names [Admin Panel]</li>
      <li>[Added] Admin ability to turn Find by Location On/Off [Admin Panel]</li>
      <li>[Added] Disable Friend Request After Decline On/Off [Admin Panel]</li>
      <li>[Added] Hide profile info from settings and profile page [Admin Panel]</li>
      <li>[Added] Set Stories Duration [Admin Panel]</li>
      <li>[Added] Show the user max file size to upload</li>
      <li>[Added] Desktop Infinite Scroll [Admin Panel]</li>
      <li>[Added] Different description for each module [SEO]</li>
      <li>[Added] Jobs & Offers to Directory [SEO]</li>
      <li>[Added] No-follow to links in the posts [SEO]</li>
      <li>[Added] Added Pages Category Description [SEO]</li>
      <li>[Added] Added Groups Category Description [SEO]</li>
      <li>[Added] Added Events Category Description [SEO]</li>
      <li>[Added] Added Offers Category Description [SEO]</li>
      <li>[Added] Added Jobs Category Description [SEO]</li>
      <li>[Added] Added Blogs Category Description [SEO]</li>
      <li>[Added] Added Marketplace Category Description [SEO]</li>
      <li>[Fixed] Minor Bugs</li>
      <li>[Fixed] FTP uploads CORS issue</li>
      <li>[Fixed] Twitch Embed issue</li>
      <li>[Fixed] Page reply to the comment notification</li>
      <li>[Fixed] Anonymous photos showing in user profile & albums</li>
      <li>[Removed] Instagram Login</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.9</span></h3>
    <blockquote>Release Date: 30th September 2020</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HTMLPurifier|HybridAuth|PHPMailer|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [bootstrap.select|codemirror|dataTables|easytimer|fluidplayer|moment|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Bootstrap|Font-Awesome]</li>
      <li>[Added] New Install/Update Wizard</li>
      <li>[Added] Live Stream Module</li>
      <li>[Added] Admin ability to turn Live Stream On/Off [Admin Panel]</li>
      <li>[Added] Live Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Offers Module</li>
      <li>[Added] Admin ability to turn Offers On/Off [Admin Panel]</li>
      <li>[Added] New System Ads Place for offers Module</li>
      <li>[Added] Jobs Module</li>
      <li>[Added] Admin ability to turn Jobs On/Off [Admin Panel]</li>
      <li>[Added] New System Ads Place for Jobs Module</li>
      <li>[Added] Changing password will logout all other sessions</li>
      <li>[Added] Security Check (Password Required) to change Email or Username</li>
      <li>[Added] Security Check (Password Required) to delete account</li>
      <li>[Fixed] og:image for links and media posts</li>
      <li>[Fixed] Shared Anonymous Post</li>
      <li>[Fixed] Profile Completion Links (Upload Profile Picture & Cover)</li>
      <li>[Fixed] Total friend requests sent count</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.8</span></h3>
    <blockquote>Release Date: 23rd June 2020</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|FTP|HybridAuth|PHPMailer|ReCaptcha|Smarty|Stripe|Twilio|2Checkout]</li>
      <li>[Updated] Sngine JS Dependencies [jQuery|bootstrap.select|codemirror|easytimer|jquery.form|moment|mustache|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Bootstrap|Font-Awesome]</li>
      <li>[Added] Enhance the Design</li>
      <li>[Added] Convert All PNG Icons to SVG</li>
      <li>[Added] Home Icon in Header</li>
      <li>[Added] Online Status on Posts</li>
      <li>[Added] Admin ability to turn Online Status on Posts On/Off [Admin Panel]</li>
      <li>[Added] Post As Anonymous</li>
      <li>[Added] Admin ability to turn Anonymous Mode on Posts On/Off [Admin Panel]</li>
      <li>[Added] OneSignal Push Notifications</li>
      <li>[Added] HTML Email Templates</li>
      <li>[Added] Distance Unit (Mile or Kilometer)</li>
      <li>[Added] Translation for DataTables</li>
      <li>[Added] Translation for Tinymce</li>
      <li>[Added] Blogs & Forums Photo Upload</li>
      <li>[Added] Admin ability to turn Blogs & Forums Photo Upload On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Pages Completely On/Off [Admin Panel]</li>
      <li>[Added] Pages Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Admin ability to turn Groups Completely On/Off [Admin Panel]</li>
      <li>[Added] Groups Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Admin ability to turn Events Completely On/Off [Admin Panel]</li>
      <li>[Added] Events Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Blogs Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Marketplace Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Forums Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Movies Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Games Privacy (Only Admins, Only Admins and Pro User or Everyone) [Admin Panel]</li>
      <li>[Added] Reset All Users's Points [Admin Panel]</li>
      <li>[Added] Admin ability to turn Infinite Scroll on Mobile On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Cover Photo Resolution Limit On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Comments Photo Upload On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Chat Photo Upload On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Wallet System On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Wallet Transfer Money On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Affiliates Withdraw Earned Money On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Affiliates Transfer Earned Money To Wallet On/Off [Admin Panel]</li>
      <li>[Added] More options for Garbage Collector [Admin Panel]</li>
      <li>[Added] More options for Newsletter [Admin Panel]</li>
      <li>[Added] Voice Notes in Posts</li>
      <li>[Added] Admin ability to turn Voice Notes in Posts On/Off [Admin Panel]</li>
      <li>[Added] Voice Notes in Comments</li>
      <li>[Added] Admin ability to turn Voice Notes in Comments On/Off [Admin Panel]</li>
      <li>[Added] Voice Notes in Chat</li>
      <li>[Added] Admin ability to turn Voice Notes in Chat On/Off [Admin Panel]</li>
      <li>[Fixed] Points System Daily Limit</li>
      <li>[Fixed] Faker Random Images</li>
      <li>[Fixed] DayTime Messages Timing</li>
      <li>[Fixed] Disable publish button while uploading</li>
      <li>[Fixed] Change SMS activation codes to be only 6 digits</li>
      <li>[Fixed] Listen to 2 audio files at same time</li>
      <li>[Fixed] Reaction translation</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.7.2</span></h3>
    <blockquote>Release Date: 20th May 2020</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Critical Bug</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.7.1</span></h3>
    <blockquote>Release Date: 24th April 2020</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Critical Bug</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.7</span></h3>
    <blockquote>Release Date: 17th February 2020</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Faker|HybridAuth|PHPMailer|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [bootstrap.colorpicker|codemirror|easytimer|mustache|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Bootstrap|Font-Awesome]</li>
      <li>[Added] Adult Images Detection System</li>
      <li>[Added] Banned Usernames</li>
      <li>[Added] Banned Email Providers</li>
      <li>[Added] Comments Sort by Top/Recent</li>
      <li>[Added] Hide Post from My Timeline</li>
      <li>[Added] New SMS BulkSMS provider</li>
      <li>[Added] New SMS Infobip provider</li>
      <li>[Added] New Storage Digitalocean</li>
      <li>[Added] New Storage FTP</li>
      <li>[Added] New Payments CoinPayments</li>
      <li>[Added] New Payments 2Checkout</li>
      <li>[Added] Revoke Apps Connection from User Settings</li>
      <li>[Added] Watermark Overlay [Admin Panel]</li>
      <li>[Added] Prevent Brute-Force Attack</li>
      <li>[Added] Admin ability to turn Brute-Force Attack Detection On/Off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Feelings/Activity Posts On/Off [Admin Panel]</li>
      <li>[Added] Static Pages Order [Admin Panel]</li>
      <li>[Added] Widgets Order [Admin Panel]</li>
      <li>[Added] WYSIWYG Editor in Admin Announcements [Admin Panel]</li>
      <li>[Added] Delete Account button in edit user page [Admin Panel]</li>
      <li>[Added] Set allowed file extension while selecting the files to upload</li>
      <li>[Fixed] Birthdate datetime format in profile page</li>
      <li>[Fixed] Delete friends & followers connections when delete user account</li>
      <li>[Fixed] Reactions box position while scrolling</li>
      <li>[Fixed] Minor Bugs</li>
      <li>[Removed] Windows Phone App</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.6.1</span></h3>
    <blockquote>Release Date: 23rd November 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|Faker|PHPMailer|reCAPTCHA|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [bootstrap.select|codemirror|datatables|easytimer|mustache|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Support for MySQL v8+</li>
      <li>[Added] Unusual Login Detection</li>
      <li>[Added] Admin ability to turn Unusual Login Detection On/Off [Admin Panel]</li>
      <li>[Added] Moderators Panel</li>
      <li>[Added] Colored Posts</li>
      <li>[Added] Admin ability to turn Colored Posts On/Off [Admin Panel]</li>
      <li>[Added] Manage Colored Posts Patterns [Admin Panel]</li>
      <li>[Added] Profile Backgrounds</li>
      <li>[Added] Admin ability enable/disable Profile Backgrounds [Admin Panel]</li>
      <li>[Added] New 404 Error Page Design</li>
      <li>[Added] Google Login with New APIs</li>
      <li>[Added] Delete Stories</li>
      <li>[Added] Affiliate URL with invite friends widget</li>
      <li>[Added] Group Admin can enable/disable Publishing Posts</li>
      <li>[Added] Group Admin can enable/disable Posts Approval System</li>
      <li>[Added] Event Admin can enable/disable Publishing Posts</li>
      <li>[Added] Event Admin can enable/disable Posts Approval System</li>
      <li>[Added] Log Out Of All Sessions</li>
      <li>[Added] Bank Transfer for Affiliates Withdrawal Requests</li>
      <li>[Added] Bank Transfer for Points Withdrawal Requests</li>
      <li>[Added] Custome Payment for Affiliates Withdrawal Requests</li>
      <li>[Added] Custome Payment for Points Withdrawal Requests</li>
      <li>[Added] Notify all system admins & moderators with Reports [Notifications]</li>
      <li>[Added] Notify all system admins & moderators with Verification Requests [Notifications]</li>
      <li>[Added] Notify all system admins with Bank Transfer [Notifications]</li>
      <li>[Added] Notify all system admins with Affiliates Withdrawal Requests [Notifications]</li>
      <li>[Added] Notify all system admins with Points Withdrawal Requests [Notifications]</li>
      <li>[Added] User Notifications with Bank Transfer Approve/Decline [Notifications]</li>
      <li>[Added] User Notifications with Affiliates Withdrawal Requests Approve/Decline [Notifications]</li>
      <li>[Added] User Notifications with Points Withdrawal Requests Approve/Decline [Notifications]</li>
      <li>[Added] Share Plugin</li>
      <li>[Added] Admin ability enable/disable Share Plugin [Admin Panel]</li>
      <li>[Added] Developers Apps</li>
      <li>[Added] Admin ability enable/disable Developers Apps [Admin Panel]</li>
      <li>[Added] Manage Posts from Admin Panel [Admin Panel]</li>
      <li>[Added] Manage Articles from Admin Panel [Admin Panel]</li>
      <li>[Added] Manage Forums Threads & Replies from Admin Panel [Admin Panel]</li>
      <li>[Added] Edit in Admin/Moderator Panel Shortcut for Profiles</li>
      <li>[Added] Edit in Admin/Moderator Panel Shortcut for Pages</li>
      <li>[Added] Edit in Admin/Moderator Panel Shortcut for Groups</li>
      <li>[Added] Edit in Admin/Moderator Panel Shortcut for Events</li>
      <li>[Added] Mark All Reports As Safe [Admin Panel]</li>
      <li>[Added] Newsletter Consent (GDPR)</li>
      <li>[Added] Admin ability to turn Newsletter Consent (GDPR) On/Off [Admin Panel]</li>
      <li>[Added] Users Insights Cards [Admin Panel]</li>
      <li>[Added] Posts Insights Cards [Admin Panel]</li>
      <li>[Added] Pages Insights Cards [Admin Panel]</li>
      <li>[Added] Pager for Pages [Admin Panel]</li>
      <li>[Added] Pager for Groups [Admin Panel]</li>
      <li>[Added] Pager for Events [Admin Panel]</li>
      <li>[Added] Order for Pages Categories [Admin Panel]</li>
      <li>[Added] Order for Groups Categories [Admin Panel]</li>
      <li>[Added] Order for Events Categories [Admin Panel]</li>
      <li>[Added] Order for Blogs Categories [Admin Panel]</li>
      <li>[Added] Order for Market Categories [Admin Panel]</li>
      <li>[Added] Order for Movies Genres [Admin Panel]</li>
      <li>[Fixed] Stop previous video when play new one</li>
      <li>[Fixed] Chat box title with long text bug</li>
      <li>[Fixed] Minor Bugs</li>
      <li>[Removed] Google+ profile link from User & Page settings & profile page</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.6</span></h3>
    <blockquote>Release Date: 21st September 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [codemirror|mustache|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Video Calls</li>
      <li>[Added] Admin ability to turn Video Calls On/Off [Admin Panel]</li>
      <li>[Added] Audio Calls</li>
      <li>[Added] Admin ability to turn Audio Calls On/Off [Admin Panel]</li>
      <li>[Added] Chat Typing Status</li>
      <li>[Added] Admin ability to turn Chat Typing Status On/Off [Admin Panel]</li>
      <li>[Added] Chat Seen Status</li>
      <li>[Added] Admin ability to turn Chat Seen Status On/Off [Admin Panel]</li>
      <li>[Added] Local Bank Transfers</li>
      <li>[Added] Admin ability to turn Bank Transfers On/Off [Admin Panel]</li>
      <li>[Added] Currencies Manager (Add/Edit/Delete) [Admin Panel]</li>
      <li>[Added] Purchases Pro-Package with Wallet Credit</li>
      <li>[Added] Admin ability to turn Purchases Pro-Package with Wallet Credit On/Off [Admin Panel]</li>
      <li>[Added] Memories</li>
      <li>[Added] Admin ability to turn Memories On/Off [Admin Panel]</li>
      <li>[Added] Discover Posts</li>
      <li>[Added] Admin ability to turn Discover Posts On/Off [Admin Panel]</li>
      <li>[Added] Popular Posts</li>
      <li>[Added] Admin ability to turn Popular Posts On/Off [Admin Panel]</li>
      <li>[Added] Poke System</li>
      <li>[Added] Admin ability to turn Poke System On/Off [Admin Panel]</li>
      <li>[Added] User Privacy for Pokes</li>
      <li>[Added] Gifts System</li>
      <li>[Added] Admin ability to turn Gifts System On/Off [Admin Panel]</li>
      <li>[Added] User Privacy for Gifts</li>
      <li>[Added] Invite Friends Widget</li>
      <li>[Added] Admin ability to turn Invite Friends Widget On/Off [Admin Panel]</li>
      <li>[Added] Max Post Characters Length [Admin Panel]</li>
      <li>[Added] Max Comment Characters Length [Admin Panel]</li>
      <li>[Added] Max Posts/Hour [Admin Panel]</li>
      <li>[Added] Max Comments/Hour [Admin Panel]</li>
      <li>[Added] Maximum Friends/User Limit [Admin Panel]</li>
      <li>[Added] Custom Home Page Wallpaper [Admin Panel]</li>
      <li>[Added] og-meta for Photo Page</li>
      <li>[Added] og-meta for Game Page</li>
      <li>[Added] Game will be Public if Website Public</li>
      <li>[Added] Verification Badge On/Off with Pro Package [Admin Panel]</li>
      <li>[Added] Free Users Daily Points Limit [Points System] [Admin Panel]</li>
      <li>[Added] Pro Users Daily Points Limit [Points System] [Admin Panel]</li>
      <li>[Fixed] Loading for modal when change from one to another</li>
      <li>[Fixed] Change Privacy of cover/profile photo post</li>
      <li>[Fixed] Delete user's pages, groups & events when delete his account</li>
      <li>[Fixed] Comments Duplicated while sending</li>
      <li>[Fixed] Change/Remove the default theme without mark other theme as default</li>
      <li>[Fixed] Minor Bugs</li>
      <li>[Removed] Intl PHP extension as requirement for Sngine</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.10</span></h3>
    <blockquote>Release Date: 21st June 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Android App</li>
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|HybridAuth v3|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [jQuery|bootstrap.colorpicker|bootstrap.select|codemirror|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Post Reactions (like, love, haha ...etc)</li>
      <li>[Added] Reactions and Share Options to Article</li>
      <li>[Added] Search Case Insensitive</li>
      <li>[Added] Support for PHP 7.3+</li>
      <li>[Added] Support for Nginx/IIS Server</li>
      <li>[Added] 2 new languages [Portuguese (Brazil) & Greek]</li>
      <li>[Added] Download User Information On/Off [Admin Panel]</li>
      <li>[Added] Auto Friend [Admin Panel]</li>
      <li>[Added] Auto Follow [Admin Panel]</li>
      <li>[Added] Auto Like [Admin Panel]</li>
      <li>[Added] Auto Join [Admin Panel]</li>
      <li>[Added] Garbage Collector [Admin Panel]</li>
      <li>[Added] Backup Database & Files [Admin Panel]</li>
      <li>[Added] Delete photos from photos page</li>
      <li>[Added] Videos Tab for Profiles</li>
      <li>[Added] Videos Tab for Pages</li>
      <li>[Added] Videos Tab for Groups</li>
      <li>[Added] Videos Tab for Events</li>
      <li>[Added] Video Views Count</li>
      <li>[Added] Audio Views Count</li>
      <li>[Added] New Video Player (fluidplayer)</li>
      <li>[Added] New Publisher Icons</li>
      <li>[Added] Trending #Hashtags</li>
      <li>[Added] Access any profile even if the user blocked the admin</li>
      <li>[Added] Admin can access any Private/Closed group/event in the system</li>
      <li>[Added] Affiliates Percentage from Package Price</li>
      <li>[Added] Custom Video Thumbnail</li>
      <li>[Added] Change Datetime Format [Admin Panel]</li>
      <li>[Added] Datetime Picker Translations</li>
      <li>[Fixed] Minor Bugs</li>
      <li>[Fixed] Album photos count & cover photo in pages, groups & events</li>
      <li>[Fixed] Disable "privacy changing" for cover photo/profile image posts</li>
      <li>[Fixed] Story close button on small screens</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.9</span></h3>
    <blockquote>Release Date: 26th April 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Added] Download My Information</li>
      <li>[Added] Profile Completion</li>
      <li>[Added] Share the post to Timeline, Page & Group</li>
      <li>[Added] Read More for long text biography in Profile, Page, Group & Event Page</li>
      <li>[Added] Search for users by email & phone [Admin Panel]</li>
      <li>[Added] Delete all user posts [Admin Panel]</li>
      <li>[Added] Delete all page posts [Admin Panel]</li>
      <li>[Added] Delete all group posts [Admin Panel]</li>
      <li>[Added] Delete all event posts [Admin Panel]</li>
      <li>[Added] Edit Custom Fields values when edit User [Admin Panel]</li>
      <li>[Added] Edit Custom Fields values when edit Page [Admin Panel]</li>
      <li>[Added] Edit Custom Fields values when edit Group [Admin Panel]</li>
      <li>[Added] Edit Custom Fields values when edit Event [Admin Panel]</li>
      <li>[Added] Delete uploaded photos after delete (comment|reply)</li>
      <li>[Added] Delete uploaded photos after delete from the album</li>
      <li>[Fixed] Social Login Form Design</li>
      <li>[Fixed] Reset Header Counter when open the dropdown</li>
      <li>[Fixed] Custom Field description bug</li>
      <li>[Fixed] Lightbox tooltip close button bug</li>
      <li>[Fixed] Can't delete replies on my own post</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.8</span></h3>
    <blockquote>Release Date: 6th April 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HybridAuth|PayPal|PHPMailer|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [bootstrap|mustache|jquery-ui|datatables|bootstrap.colorpicker|bootstrap.datetimepicker|bootstrap.select|codemirror|moment|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Sngine Default Theme v2.0 with Bootsrap 4+</li>
      <li>[Added] Night Mode On/Off</li>
      <li>[Added] Chat Message Sound On/Off ability</li>
      <li>[Added] Update @Mention functionality</li>
      <li>[Added] Disable Infinite Scroll on Mobile</li>
      <li>[Added] Custom Fields description & value translation ability</li>
      <li>[Fixed] Edit Post more than 2 time bug</li>
      <li>[Fixed] Messages counter on Mobile</li>
      <li>[Fixed] Comments count after delete replies</li>
      <li>[Fixed] Declined friend request on profile page</li>
      <li>[Fixed] Stroies with videos only publish bug</li>
      <li>[Fixed] UTF-8 Hashtags in Posts & Comments</li>
      <li>[Fixed] UTF-8 Names in Email & Noty Notifications</li>
      <li>[Fixed] UTF-8 Tags in Articles</li>
      <li>[Fixed] All Reported Bugs</li>
      <li>[Removed] Google+ Login</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.7</span></h3>
    <blockquote>Release Date: 10th January 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.6</span></h3>
    <blockquote>Release Date: 1st January 2019</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HybridAuth|PHPMailer|ReCaptcha|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [mustache|bootstrap.select|codemirror|metismenu|moment|readmore|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Delete Uploaded (Photos, Video, Audio, File) after deleting posts</li>
      <li>[Added] Fake User Generator</li>
      <li>[Added] Verification Attachments for Users</li>
      <li>[Added] Verification Attachments for Pages</li>
      <li>[Added] Admin ability to turn Two-Factor Authentication On/Off</li>
      <li>[Added] Two-Factor Authentication via Email & Phone</li>
      <li>[Added] Two-Factor Authentication via Google Authenticator App</li>
      <li>[Added] New verification system for email & phone number</li>
      <li>[Added] Twitter Card Meta Tags</li>
      <li>[Added] Popular Posts</li>
      <li>[Added] Last Played Time in Games</li>
      <li>[Added] Use CDN for Bootstrap, FontAwesome & jQuery files</li>
      <li>[Added] Added Server Side Pager to Users in Admin Panel</li>
      <li>[Added] All AWS S3 Regions (10+ New Regions)</li>
      <li>[Added] robots.txt file</li>
      <li>[Added] Progress Bar for all uploadings</li>
      <li>[Added] Keyboard Shortcuts to scroll between posts</li>
      <li>[Added] New Publisher</li>
      <li>[Added] GIFs Support by Giphy in Publisher</li>
      <li>[Added] Admin ability to turn Giphy support in publisher On/Off</li>
      <li>[Added] Auto Ad-block Detector</li>
      <li>[Added] Admin ability to turn Auto Ad-block Detector On/Off</li>
      <li>[Added] Auto Ad-block Warning Message in admin panel ads control</li>
      <li>[Added] Auto Ad-block Warning Message in user ads manager</li>
      <li>[Added] New Stories System</li>
      <li>[Added] New Stories Publisher</li>
      <li>[Added] Videos in Stories</li>
      <li>[Added] New Product Publisher</li>
      <li>[Added] Product Status New or Old</li>
      <li>[Added] Product Price can be 0 or Free Product</li>
      <li>[Added] Edit button when edit post from mobile</li>
      <li>[Added] Edit button when edit comment/reply from mobile</li>
      <li>[Added] New Album (Add Photos) Publisher</li>
      <li>[Added] Turn Post Commenting On/Off</li>
      <li>[Added] Share Affiliates link</li>
      <li>[Added] Share post to Whatsapp</li>
      <li>[Added] Admin ability to change user points balance</li>
      <li>[Added] Admin ability to turn Points System on/off</li>
      <li>[Added] Points System</li>
      <li>[Added] Ads in Movies</li>
      <li>[Added] Admin ability to turn Movies System on/off</li>
      <li>[Added] Movies System</li>
      <li>[Added] Find Friends by location</li>
      <li>[Added] Changelog to admin panel</li>
      <li>[Fixed] Multiple stories for same user in same day</li>
      <li>[Fixed] Reposition cover photo on mobile</li>
      <li>[Fixed] _emoji-menu tabs in chat</li>
      <li>[Fixed] Post Privacy in Publisher</li>
      <li>[Fixed] Delete stories images in Publisher</li>
      <li>[Fixed] Publisher submit disabled while link scraping</li>
      <li>[Fixed] Open "Edit Post" several times</li>
      <li>[Fixed] Forum Thread Views Count</li>
      <li>[Fixed] Getting notifications from deleted users</li>
      <li>[Fixed] All Reported Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.5</span></h3>
    <blockquote>Release Date: 6th October 2018</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.4</span></h3>
    <blockquote>Release Date: 10th September 2018</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HybridAuth|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [autosize|bootstrap.colorpicker|codemirror|datatables|mediaelement|metismenu|moment|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome]</li>
      <li>[Added] Secured Cookies [GDPR]</li>
      <li>[Added] Cookies Consent Notification [GDPR]</li>
      <li>[Added] Admin ability to turn Cookies Consent Notification On/Off [GDPR]</li>
      <li>[Added] Privacy Checkbox in Sign Up [GDPR]</li>
      <li>[Added] Newsletter Checkbox in User Settings [GDPR]</li>
      <li>[Added] Directions RTL & LTR in WYSIWYG Editor</li>
      <li>[Added] Language Flag instead of icon</li>
      <li>[Added] Admin ability to change user wallet balance</li>
      <li>[Added] Admin ability to turn articles for users on/off [Admin Panel]</li>
      <li>[Added] Delete article button from article page</li>
      <li>[Added] Crop/Edit Profile Photo for Users</li>
      <li>[Added] Crop/Edit Profile Photo for Pages</li>
      <li>[Added] Crop/Edit Profile Photo for Groups</li>
      <li>[Added] Adjust Profile Cover Position for Users</li>
      <li>[Added] Adjust Profile Cover Position for Pages</li>
      <li>[Added] Adjust Profile Cover Position for Groups</li>
      <li>[Added] User isn't able to see blocked users comments at any posts and vice versa</li>
      <li>[Added] User isn't able to see blocked users posts in mutual groups & events and vice versa</li>
      <li>[Added] Ads in Article</li>
      <li>[Added] Widget in Article</li>
      <li>[Added] Chat box name now clickable [Chat]</li>
      <li>[Added] Chat Colors [Chat]</li>
      <li>[Added] Blog Categories</li>
      <li>[Added] Manage Blog Categories in Admin Panel</li>
      <li>[Added] Abilty to post mobile emojies on posts, comments, and messages</li>
      <li>[Fixed] Disable blocked people from sent chat messages [Chat]</li>
      <li>[Fixed] When I delete the message of the “X” friend, then the friend “X” message to me but not display [Chat]</li>
      <li>[Fixed] Forums Order Bug</li>
      <li>[Fixed] Verified badge on Search Results & Notifactions</li>
      <li>[Fixed] Uploaded GIF image check</li>
      <li>[Fixed] Article URL for better SEO</li>
      <li>[Fixed] Pin/Unpin Posts for Pages</li>
      <li>[Fixed] Boost/Unboost Posts if package's limit reached</li>
      <li>[Fixed] Deleted Articles in Search Results</li>
      <li>[Fixed] Notification post forum reply bug</li>
      <li>[Fixed] Event location if empty</li>
      <li>[Fixed] Negative amount in wallet transfer</li>
      <li>[Fixed] Empty post bug</li>
      <li>[Fixed] Upload page/group picture/cover from different admin</li>
      <li>[Fixed] Delete page/group picture/cover from different admin</li>
      <li>[Fixed] Blocked users from people you may know</li>
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.3</span></h3>
    <blockquote>Release Date: 20th May 2018</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Documentation</li>
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HybridAuth|PayPal|PHPMailer|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [jQuery|dataTables|mediaelement|metisMenu|moment|noty|tinymce]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome|Flag-Icon]</li>
      <li>[Added] Advanced ADS system for users</li>
      <li>[Added] User Wallet System</li>
      <li>[Added] Send message button in mobile version</li>
      <li>[Added] Posts Translation</li>
      <li>[Added] "Add New Product" button in Market & My Products</li>
      <li>[Added] Social Links for Pages</li>
      <li>[Added] Action Button for Pages</li>
      <li>[Added] Groups Categories</li>
      <li>[Added] Custom Fields Order</li>
      <li>[Added] Custom Fields for Pages</li>
      <li>[Added] Custom Fields for Groups</li>
      <li>[Added] Custom Fields for Events</li>
      <li>[Added] Links posts to newsfeed filter</li>
      <li>[Added] Media posts to newsfeed filter</li>
      <li>[Added] Custom JavaScript Code (Header & Footer) from Admin Panel</li>
      <li>[Added] Garbage collector to remove all expired subscribers and their boosted posts and pages from Admin Panel</li>
      <li>[Added] Static Pages title can be translated</li>
      <li>[Added] Articles in search results</li>
      <li>[Added] Article cover in article content</li>
      <li>[Added] Work website to profile info</li>
      <li>[Added] Country to profile info</li>
      <li>[Added] Manage my boosted posts</li>
      <li>[Added] Manage my boosted pages</li>
      <li>[Added] Manage Group Members</li>
      <li>[Added] Multiple Admins for Groups</li>
      <li>[Added] Manage Page Members</li>
      <li>[Added] Multiple Admins for Pages</li>
      <li>[Fixed] Link scraper trigger</li>
      <li>[Fixed] Left sidebar scroll</li>
      <li>[Fixed] Social signup first name and last name duplication</li>
      <li>[Fixed] VK Social Login</li>
      <li>[Fixed] Admin newsletter error due to timeout</li>
      <li>[Fixed] Exclude hidden posts from boosted posts</li>
      <li>[Fixed] Remove all boosted posts/pages after user package expired</li>
      <li>[Fixed] Banned users in "People you may know"</li>
      <li>[Fixed] Boost button is still here in Page even if you have disabled pro</li>
      <li>[Fixed] Lightbox arrows position on mobile</li>
      <li>[Fixed] Special characters in notifications</li>
      <li>[Fixed] All Reported Bugs</li>

      <li>[Removed] Bitcoin Payments</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.2</span></h3>
    <blockquote>Release Date: 1st March 2018</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [Twilio]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome(v5)]</li>
      <li>[Added] Forums</li>
      <li>[Added] Mass Notifications from Admin Panel</li>
      <li>[Added] Change Language from URL</li>
      <li>[Added] Enhanced Static Pages in Admin Panel [Admin Panel]</li>
      <li>[Added] Add Geolocation Map in Event Page</li>
      <li>[Added] Admin ability to turn Polls on/off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Browser Notifications on/off [Admin Panel]</li>
      <li>[Added] Admin ability to turn Noty Notifications on/off [Admin Panel]</li>
      <li>[Added] Invitations System</li>
      <li>[Added] Other Gender</li>
      <li>[Added] Edit Phone Number from User Settings</li>
      <li>[Added] Admin ability to edit user Phone Number [Admin Panel]</li>
      <li>[Added] Photo Quality (High|Medium|Low) [Admin Panel]</li>
      <li>[Added] Dynamic og-meta Tags</li>
      <li>[Fixed] Name validation rules</li>
      <li>[Fixed] Search find only a single word</li>
      <li>[Fixed] Find people filters with empty query</li>
      <li>[Fixed] Disabled pages/groups/events and user can see them but can't create</li>
      <li>[Fixed] Left sidebar scroll</li>
      <li>[Fixed] Delete old profile/cover photos delete the current one too</li>
      <li>[Fixed] Message button on mobile need to enter username again</li>
      <li>[Fixed] All Reported Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5.1</span></h3>
    <blockquote>Release Date: 19th November 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Minor Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.5</span></h3>
    <blockquote>Release Date: 9th November 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] System Security</li>
      <li>[Updated] System Optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HybridAuth|PayPal|PHPMailer|ReCaptcha|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [jQuery|jquery.form|jquery.inview|jquery.geocomplete|autosize|moment|mediaelementplayer|bootstrap.select|bootstrap.datetimepicker|bootstrap.colorpicker|metisMenu|dataTables]</li>
      <li>[Updated] Installer Wizard & Pre-Installation Check</li>
      <li>[Updated] Sngine GTmetrix Optimization</li>
      <li>[Updated] Sngine Google PageSpeed Optimization</li>
      <li>[Added] Romanian Language</li>
      <li>[Added] Events</li>
      <li>[Added] Admin ability to turn Events on/off [Admin Panel]</li>
      <li>[Added] Group Privacy (Public, Closed & Secret)</li>
      <li>[Added] New Group Layout</li>
      <li>[Added] Discover Pages</li>
      <li>[Added] Discover Groups</li>
      <li>[Added] Discover People</li>
      <li>[Added] Blogs</li>
      <li>[Added] Admin ability to turn Blogs on/off [Admin Panel]</li>
      <li>[Added] Invite Friends to Events</li>
      <li>[Added] Invite Friends to Pages</li>
      <li>[Added] Invite Friends to Groups</li>
      <li>[Added] Stories</li>
      <li>[Added] Admin ability to turn Stories on/off [Admin Panel]</li>
      <li>[Added] DayTime Messages (Good Morning, Afternoon, Evening)</li>
      <li>[Added] Admin ability to turn DayTime Messages on/off [Admin Panel]</li>
      <li>[Added] Replies</li>
      <li>[Added] Reply to Reply</li>
      <li>[Added] Comment Button for Mobile</li>
      <li>[Added] Emojies to the Publisher</li>
      <li>[Added] Stickers in [Posts|Comments|Chat]</li>
      <li>[Added] Emojis Center in admin panel [Admin Panel]</li>
      <li>[Added] Stickers Center in admin panel [Admin Panel]</li>
      <li>[Added] Discover Games</li>
      <li>[Added] User Played Games</li>
      <li>[Added] Recent Searches</li>
      <li>[Added] Browser Push Notifications</li>
      <li>[Added] Notification Highlights</li>
      <li>[Added] Noty Notifications</li>
      <li>[Added] Notifications Sound Toggle On/Off</li>
      <li>[Added] Friend Request email notification</li>
      <li>[Added] Posts Socail Share (Facebook, Twitter, ...etc)</li>
      <li>[Added] Admin ability to turn Socail Share on/off [Admin Panel]</li>
      <li>[Added] Add YouTube Smart Player (Better Performance)</li>
      <li>[Added] Admin ability to turn YouTube Smart Player on/off [Admin Panel]</li>
      <li>[Added] Posts Settings [Admin Panel]</li>
      <li>[Added] PRO Package Membership Management [User Settings]</li>
      <li>[Added] PRO Package Membership Management [Admin Panel]</li>
      <li>[Added] First Name + Last Name instead of Full Name</li>
      <li>[Added] Login with Email or Username</li>
      <li>[Added] Sessions & IPs info in edit users [Admin Panel]</li>
      <li>[Added] Admin ability to turn Home Random Profiles on/off [Admin Panel]</li>
      <li>[Added] Change Default Publisher Privacy from Admin Panel [Admin Panel]</li>
      <li>[Added] Newsletter accept HTML Email Templates [Admin Panel]</li>
      <li>[Added] @mentions now support UTF-8 charset</li>
      <li>[Added] Notifications after @mention after edit post/comment</li>
      <li>[Added] Ads in newsfeed</li>
      <li>[Added] Ads in Marketplace</li>
      <li>[Added] Enhance Ads designs & locations [Admin Panel]</li>
      <li>[Added] Enhance Widgets designs & locations [Admin Panel]</li>
      <li>[Added] New Passwords Hash System instead of MD5/SHA1</li>
      <li>[Added] Enhanced the debugging mode</li>
      <li>[Added] Sticky Sidebar in Homepage & Directory</li>
      <li>[Added] New default users, pages and groups profile picture</li>
      <li>[Fixed] CSS Bugs</li>
      <li>[Fixed] All Reported Bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.4.3</span></h3>
    <blockquote>Release Date: 29th July 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Android APP</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.4.2</span></h3>
    <blockquote>Release Date: 21th March 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] System optimization</li>
      <li>[Updated] Sngine JS Dependencies [mediaelementplayer]</li>
      <li>[Added] Stripe Receipt Email</li>
      <li>[Fixed] Page Verification Request</li>
      <li>[Fixed] Minor CSS bugs</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.4.1</span></h3>
    <blockquote>Release Date: 15th March 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Fixed] Admin ability to boost posts & pages without package</li>
      <li>[Fixed] Poll bug</li>
      <li>[Fixed] Installer CSS</li>
      <li>[Fixed] Verification Bug</li>
      <li>[Fixed] Manage Pages/Groups Bug</li>
      <li>[Fixed] Show Online Friends on Mobile</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.4</span></h3>
    <blockquote>Release Date: 6th March 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] System Security</li>
      <li>[Updated] System optimization</li>
      <li>[Updated] Sngine Libs [AWS|Embed|HybridAuth|PayPal|PHPMailer|reCAPTCHA|Smarty|Stripe|Twilio]</li>
      <li>[Updated] Sngine JS Dependencies [jQuery|Bootstrap|Mustache|html5shiv|slimscroll|autosize|readmore|moment|datetimepicker|DataTables]</li>
      <li>[Updated] Sngine CSS Dependencies [Font-Awesome|Twemoji-Awesome|Flag-Icon]</li>
      <li>[Updated] Installer Wizard & Pre-Installation Check</li>
      <li>[Added] New Mobile UI Enhancement</li>
      <li>[Added] Support RTL text with LRT languages</li>
      <li>[Added] Charts to Admin Panel</li>
      <li>[Added] Enable/Disable Directory from admin panel</li>
      <li>[Added] Enable/Disable Market from admin panel</li>
      <li>[Added] Enable/Disable Contact us page from admin panel</li>
      <li>[Added] Contact Us page</li>
      <li>[Added] Enable/Disable Verification Requests from admin panel</li>
      <li>[Added] Enable/Disable Advanced Link Scraper from admin panel</li>
      <li>[Added] Advanced Link Scraper (to support short links like: https://youtu.be/5J...)</li>
      <li>[Added] Registration via Subscriptions Only</li>
      <li>[Added] Enable/Disable Pro Packages from admin panel </li>
      <li>[Added] SMS Verfication</li>
      <li>[Added] Registration age restriction</li>
      <li>[Added] New Social Login [Instagram]</li>
      <li>[Added] SMTP SSL Encryption</li>
      <li>[Added] SMTP setFrom Email Address</li>
      <li>[Added] Test SMTP Connection from admin panel</li>
      <li>[Added] Email Notifications</li>
      <li>[Added] Enable/Disable Email notifications from admin panel</li>
      <li>[Added] SMS via Twilio</li>
      <li>[Added] Test SMS API Connection from admin panel</li>
      <li>[Added] Amazon S3 integration for uploads</li>
      <li>[Added] Payments Settings in admin panel</li>
      <li>[Added] PayPal payments</li>
      <li>[Added] CreditCard, BitCoin, Alipay payments</li>
      <li>[Added] 24 Currency</li>
      <li>[Added] Edit index wallpaper from admin panel</li>
      <li>[Added] Ability to add free custom CSS from admin panel</li>
      <li>[Added] Manage Market Categories from admin panel</li>
      <li>[Added] Manage Pro Packages</li>
      <li>[Added] Ability to Customize Pro Packages</li>
      <li>[Added] Manage Pro Subscribers</li>
      <li>[Added] Report Pro Packages Earnings</li>
      <li>[Added] Affiliates System</li>
      <li>[Added] Manage Affiliates Settings from admin panel</li>
      <li>[Added] Manage Affiliates Withdrawal Requests from admin panel</li>
      <li>[Added] Reports Enhancements in admin panel</li>
      <li>[Added] Blocking (Banned IPs) in admin panel</li>
      <li>[Added] Verification Requests for Users</li>
      <li>[Added] Verification Requests for Pages</li>
      <li>[Added] Verification Requests Manager in admin panel</li>
      <li>[Added] Custom User Profile Fields</li>
      <li>[Added] Privacy Settings for Custom Profile Fields</li>
      <li>[Added] Staic Pages in footer menu option</li>
      <li>[Added] Newsletter (aka Mailing list)</li>
      <li>[Added] Add multiple ads in the same place</li>
      <li>[Added] Add multiple widgets in the same place</li>
      <li>[Added] Relationship Status, Biography, Website & Social Links in user profile</li>
      <li>[Added] Mutiple Sessions </li>
      <li>[Added] Mutiple Sessions Manager from user settings</li>
      <li>[Added] Enable/Disable Email notifications from user settings</li>
      <li>[Added] Enhance Username Validation (with reserved words)</li>
      <li>[Added] Make System Path in the config file not the database</li>
      <li>[Added] Manage User Affiliates from from user settings</li>
      <li>[Added] Manage User Affiliates Withdrawal Requests from user settings</li>
      <li>[Added] Post Feelings</li>
      <li>[Added] Polls</li>
      <li>[Added] Market</li>
      <li>[Added] Add verified icon with search results</li>
      <li>[Fixed] Installation with STRICT_TRANS_TABLES SQL mode defined</li>
      <li>[Fixed] Mobile image orientation after uploading</li>
      <li>[Fixed] Visitor "like, share & comment" issue</li>
      <li>[Fixed] Publisher dropdown menu if video/audio/file upload are disabled</li>
      <li>[Fixed] Privacy settings for chat when chat is disabled by the admin</li>
      <li>[Fixed] Link scraper 'http://..' typing error message</li>
      <li>[Fixed] Image uploader CSS bug</li>
      <li>[Fixed] Recaptcha CSS bug in sign up & home page</li>
      <li>[Fixed] GIF Player CSS bug</li>
      <li>[Fixed] CloudFlare IP addresses</li>
      <li>[Fixed] Publisher textarea height after new post</li>
      <li>[Fixed] Comment textarea height after new comment</li>
      <li>[Fixed] User's privacy settings of [friends|pages|groups] for visitors</li>
      <li>[Fixed] Read more with fixed height not number of lines for post and comment</li>
      <li>[Fixed] Chat Bugs</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.3.1</span></h3>
    <blockquote>Release Date: 22th March 2017</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Sngine Libs [PHPMailer]</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.3</span></h3>
    <blockquote>Release Date: 3rd September 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Sngine Dependencies [Bootstrap|Font-Awesome|Flag-Icon|Twemoji-Awesome]</li>
      <li>[Updated] Cache system to speed up your website (97/100 on Google PageSpeed)</li>
      <li>[Updated] System Security</li>
      <li>[Updated] Improve Search to include wall posts and group posts</li>
      <li>[Added] Directory [Posts|Users|Pages|Groups|Games] for better SEO</li>
      <li>[Added] Photos section in User Profile</li>
      <li>[Added] Photos section in Pages</li>
      <li>[Added] Photos section in Groups</li>
      <li>[Added] Photo Albums for Users</li>
      <li>[Added] Photo Albums for Pages</li>
      <li>[Added] Photo Albums for Groups</li>
      <li>[Added] Google Map API integration</li>
      <li>[Added] Wall posts</li>
      <li>[Added] Edit Post</li>
      <li>[Added] Save Post</li>
      <li>[Added] Pin Post</li>
      <li>[Added] Edit Comment</li>
      <li>[Added] Announcements</li>
      <li>[Added] Timeline Filter</li>
      <li>[Added] New posts loader</li>
      <li>[Added] "Only me" as a new privacy for posts</li>
      <li>[Added] Time Translation [like “7 hours ago”]</li>
      <li>[Added] Groups posts on newsfeed</li>
      <li>[Added] New privacy settings for [Birthdate|Work|Location|Education] info</li>
      <li>[Added] New privacy settings for Wall posts [who can post on your wall]</li>
      <li>[Added] Make the search public for visitors</li>
      <li>[Added] Add/Change Favicon from admin panel</li>
      <li>[Added] Add/Change og-image from admin panel</li>
      <li>[Added] Enable/Disable wall posts from admin panel</li>
      <li>[Added] Search page as a new place for Ads & Widgets</li>
      <li>[Added] Search page as a new place for Ads & Widgets</li>
      <li>[Added] Improved email function/settings</li>
      <li>[Added] Make [User|Page|Group] profile picture & cover picture clickable</li>
      <li>[Fixed] Duplicated Posts</li>
      <li>[Fixed] Last seen time</li>
      <li>[Fixed] Report page & group</li>
      <li>[Fixed] Chat box name with special characters</li>
      <li>[Fixed] embed-ifram videos width</li>
      <li>[Fixed] Video Player for iPhone videos</li>
      <li>[Fixed] Admin reported post privacy</li>
      <li>[Fixed] Uploaded extensions check function</li>
      <li>[Fixed] See more line drop for long text</li>
      <li>[Fixed] Minor bugs</li>
      <li>[Removed] Material Theme</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.2.1</span></h3>
    <blockquote>Release Date: 26th July 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Updated] Sngine Dependencies [Smarty|HybridAuth|Google reCAPTCHA]</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.2</span></h3>
    <blockquote>Release Date: 30th April 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] [Apps] Android APP</li>
      <li>[Added] [Apps] IOS APP</li>
      <li>[Added] [Apps] Windows Phone App</li>
      <li>[Added] [Admin] Website Public option | Disable it to prevent non logged users to view website</li>
      <li>[Added] [Admin] Cache System | Enable cache system to speed up your website</li>
      <li>[Added] [Admin] Webiste Keywords for better SEO</li>
      <li>[Added] [Admin] Pages Enabled | Users can create pages or only admins/moderators</li>
      <li>[Added] [Admin] Groups Enabled | Users can create groups or only admins/moderators</li>
      <li>[Added] [Admin] Profile visit notification | Turn the profile visit notification On and Off</li>
      <li>[Added] [Admin] Geolocation Enabled | Turn the post Geolocation On and Off</li>
      <li>[Added] [Admin] Getting started page | Enable/Disable getting started page after registration</li>
      <li>[Added] [Admin] Delete Account option | Allow users to delete their account</li>
      <li>[Added] [Admin] Accounts/IP | Number of accounts allowed to register per IP (0 for unlimited)</li>
      <li>[Added] [Admin] Chat Enabled | Turn the chat system On and Off</li>
      <li>[Added] [Admin] User Status Enabled | Turn the Last Seen On and Off</li>
      <li>[Added] [Admin] Uploads Prefix | Add a prefix to the uploaded files</li>
      <li>[Added] [Admin] Photo Upload | Enable photo upload to share & upload photos to the site</li>
      <li>[Added] [Admin] Allowed video extensions | Allowed video extensions (separated with comma ',)</li>
      <li>[Added] [Admin] Audio Upload | Enable audio upload to share & upload sounds to the site</li>
      <li>[Added] [Admin] Max audio size | The Maximum size of uploaded audio in posts in kilobytes (1M = 1024KB)</li>
      <li>[Added] [Admin] Allowed audio extensions | Allowed audio extensions (separated with comma ',)</li>
      <li>[Added] [Admin] File Upload | Enable file upload to share & upload sounds to the site</li>
      <li>[Added] [Admin] Max file size | The Maximum size of uploaded file in posts in kilobytes (1M = 1024KB)</li>
      <li>[Added] [Admin] Allowed file extensions | Allowed file extensions (separated with comma ',)</li>
      <li>[Added] [Admin] Censored Words Enabled | Enable/Disable Words to be censored</li>
      <li>[Added] [Admin] Censored Words | Words to be censored, separated by a comma (,)</li>
      <li>[Added] [Admin] Data Heartbeat | The update interval to check for new data (in seconds)</li>
      <li>[Added] [Admin] Chat Heartbeat | The update interval to check for new messages (in seconds)</li>
      <li>[Added] [Admin] Offline after | The amount of time to be considered online since the last user's activity (in seconds)</li>
      <li>[Added] [Admin] Custom Design</li>
      <li>[Added] [Admin] Build Version in admin panel main menu</li>
      <li>[Added] Update all Sngine Dependencies to latest version</li>
      <li>[Added] Uploads folder now arranged with years/months and file types like WordPress</li>
      <li>[Added] Getting started page</li>
      <li>[Added] User now can upload and share audio file</li>
      <li>[Added] User now can upload and share any file</li>
      <li>[Added] New video player with more advanced features</li>
      <li>[Added] New audio player with more advanced features</li>
      <li>[Added] Improved Security</li>
      <li>[Fixed] Chat on mobile and remove chat heads</li>
      <li>[Fixed] Hashtag pattern to support (_) like #hash_hash</li>
      <li>[Fixed] Load More in public mode</li>
      <li>[Fixed] Privacy of posts for only friends in public mode</li>
      <li>[Fixed] Image remover after upload in publisher</li>
      <li>[Fixed] Username validation (admin and must be 3 char)</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.1</span></h3>
    <blockquote>Release Date: 16th February 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] Sngine 2.1 Structure for better caching and performance</li>
      <li>[Added] Sngine APIs v1.0</li>
      <li>[Added] Transfer Awesome features from Material theme to default theme</li>
      <li>[Added] New Social Logins [Linkedin & Vkontakte]</li>
      <li>[Added] New Link Scraper</li>
      <li>[Added] New Documentation</li>
      <li>[Added] og-meta tags for Social Marketing</li>
      <li>[Fixed] Chat messages duplication</li>
      <li>[Fixed] SMTP Emails CharSet encoding</li>
      <li>[Fixed] RTL Chatbox Icons alignment "Arabic Language"</li>
      <li>[Fixed] Post word-break</li>
      <li>[Fixed] Material design icons render</li>
      <li>[Fixed] See more for visitor</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.0.5</span></h3>
    <blockquote>Release Date: 20th January 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] New Theme [Material Theme]</li>
      <li>[Added] Android APP</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.0.4</span></h3>
    <blockquote>Release Date: 12th January 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] Enable/Disable videos from admin panel</li>
      <li>[Added] Upload site logo from admin panel</li>
      <li>[Added] Delete user account from admin panel</li>
      <li>[Added] Delete user from settings page</li>
      <li>[Added] Security enhancements</li>
      <li>[Fixed] Fixed links on iPhone</li>
      <li>[Fixed] Comments encoding problem</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.0.3</span></h3>
    <blockquote>Release Date: 4th January 2016</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] Update the settings page structure in admin panel</li>
      <li>[Added] Verified sign beside user name in post/comment header </li>
      <li>[Added] infinite scroll</li>
      <li>[Added] Report Page/Group</li>
      <li>[Added] Video Post & Video Uploader</li>
      <li>[Added] Google Analytics Code from Admin Panel</li>
      <li>[Added] Set Max uploaded (Profile Picture, Cover Photo, Uploaded Photo & Uploaded Video) size from Admin Panel</li>
      <li>[Added] Photo Gallery </li>
      <li>[Added] Next & Prev Photo for lightbox</li>
      <li>[Added] Uploading Multiple Images</li>
      <li>[Added] Updated Profile Picture/Cover Photo Posts</li>
      <li>[Fixed] Website description Bug</li>
      <li>[Fixed] People you may know will show only activated people (with email confirmation)</li>
      <li>[Fixed] Posting to the group issue</li>
      <li>[Fixed] Photos Grid System</li>
      <li>[Fixed] Single photo post comments/likes</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.0.2</span></h3>
    <blockquote>Release Date: 5th December 2015</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] Social Logins (Facebook, Twitter, Google) </li>
      <li>[Added] Linked Accounts (Facebook, Twitter, Google)</li>
      <li>[Added] Admin Panel Login while system shutdown with no problem</li>
      <li>[Added] Reduce Image size and handle uploader security </li>
      <li>[Added] UI Enhancements (From your feedback)</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.0.1</span></h3>
    <blockquote>Release Date: 16th November 2015</blockquote>
    <ul class="change-log-list mb20">
      <li>[Added] All UI edits for mobile/desktop Layout.</li>
      <li>[Added] Add 7 new languages. (10 Languages now available)</li>
      <li>[Added] Add the widgets (So admin can add widget like Like Facebook Page ...etc) </li>
      <li>[Added] Start the Plugins engine.</li>
      <li>[Added] Add 1st Plugin (Games)</li>
      <li>[Added] Add the User the Ability to delete their own Pages/Groups.</li>
      <li>[Added] Add the mutual friends counter on user profile.</li>
      <li>[Added] Add shared post title</li>
      <li>[Added] New Static pages appear in the footer</li>
      <li>[Added] Add who share a post.</li>
      <li>[Added] Admin can delete post directly from post's menu</li>

      <li>[Fixed] Fixed the suggested pages/groups section (get only new pages/groups)</li>
      <li>[Fixed] Minor bugs</li>
    </ul>
    <div class="divider"></div>

    <h3>Version <span class="badge bg-warning rounded-pill">2.0.0</span></h3>
    <blockquote>Release Date: 6th November 2015</blockquote>
    <ul class="change-log-list mb20">
      <li>[Initial] Initial version</li>
    </ul>
    <!-- Changelog -->

  </div>
</div>